define(['app', 'angular'], function (app, angular) {
	app.directive('list', function () {
		return {
			restrict: 'AE',
			scope: {
				'listItems' : '=',
				'itemTemplateUrl' : '@',
				'itemTemplateUrlAttr' : '@',
				'itemIsSelectedComparator' : '&',
				'onItemClick' : '&'
			},
			link: function(scope, element, attrs) {
				scope.getItemTemplateUrl = function(item) {
					return attrs.itemTemplateUrlAttr ? item[attrs.itemTemplateUrlAttr] : attrs.itemTemplateUrl;
				}
			},
			templateUrl: 'src/container/components/content/list/list_template.html'
		};
	});
});